#----------------------------------------------------------------------------------#
# Program Name   : Chapter2_Section2.5
#----------------------------------------------------------------------------------#

start.time <- proc.time()[3]


#   Read Data and conduct summary statistics
lot <- c("A", "B", "C", "D", "E",  "F", "G", "H")
purity <- c(94.20, 92.68, 94.47, 94.14, 95.17, 94.47, 94.14, 95.17)
tbl21.ds <- data.frame(Lot = lot, Purity=purity)

#---  confidence interval for mean 2.5.1  ---#
t.test(purity)

#---  confidence interval for variance 2.5.2 - 2.5.4 ---#
var.interval <- function(data, conf.level = 0.95)
{
    df <- length(data) - 1
    csqlower <- qchisq((1 - conf.level)/2, df)
    csqupper <- qchisq((1 - conf.level)/2, df, lower.tail = FALSE)
    ms <- var(data)
    vci <- c((df * ms)/csqupper,  (df * ms)/csqlower)   # conf int for var
    sdci <- sqrt(vci)                                   # conf int for std deviation
    rsdci <- 100*sdci/mean(data)                        # conf int for RSD
    res <- data.frame(Variance = vci, StdDev = sdci, RSD = rsdci)
    return(res)
}

var.interval(purity)

#  confidence intervalf for OOS  2.5.5 --------#
delnct<-function(x,p,df,prec=1e-10) {
    #
    # Program by Henrik Spliid, Technical University of Denmark.
    # email: hspl at dtu dot dk
    #
    # Compute the t-noncentrality parameter for given x, p and df.
    #
    d1<-x
    f1<-p-pt(x,df,d1)
    d2<-d1-2
    if (f1<=0) {d2<-d1+2}
    f2<-p-pt(x,df,d2)
    #
    # d1 and d2 are (very) crude starting points.
    # Could be improved, but the gain will be small because
    # f(del)=p-pt(x,df,del) is nicely smooth and monotonic.
    #
    f3<-1
    while(abs(f3)>prec){
        d3 <- d1-f1*(d2-d1)/(f2-f1)
        f3<-p-pt(x,df,d3)
        if (abs(f2)>abs(f1)) {d2<-d3;f2<-f3}
        else {d1<-d3;f1<-f3}
    }
    delnct<-d3
    delnct
}

delnct(22.86, 0.025, 7)
delnct(22.86, 0.975, 7)

oos.interval <- function(data, spec.limit, conf.level = 0.95)
{
    nobs <- length(data)
    df <- length(data) - 1
    alpha  <- ( 1 - conf.level)/2
    tvalue <- sqrt(length(data))*abs((mean(data) - spec.limit)/ sd(data))
    lambda.lower <- delnct(tvalue, alpha, df )
    lambda.upper <- delnct(tvalue, 1 - alpha, df)
    
    oos.lbnd <- 1 - pnorm(lambda.lower/sqrt(nobs))
    oos.ubnd <- 1 - pnorm(lambda.upper/sqrt(nobs))
    return(c(oos.lbnd, oos.ubnd))
    
}

oos.interval(purity, 88, 0.95)
oos.interval(purity, 100, 0.95)

#---   predition confidence interval  2.5.6 ---#
library("faraway")
purity.m <- lm(Purity ~ 1, data = tbl21.ds)
predict(purity.m, newdata = NULL, interval = "predict")[1,]

#---  tolerance interval    2.5.7 ---#
library("tolerance")
normtol.int(x = purity, alpha = 0.05, P = 0.99, side=2, method = "HE")
normtol.int(x = purity, alpha = 0.05, P = 0.99, side=2, method = "WBE")
normtol.int(x = purity, alpha = 0.01, P = 0.90, side =1)

# End of script
cat("\n"); cat("Time Elapsed (hour): ", (proc.time()[3]-start.time)/3600, "\n")
rm(list=ls(all=TRUE))
#---------------------------------------------------------------------------------------#
#                                End of script
#---------------------------------------------------------------------------------------#